<%@ Page Title="TBI Instruments - Follow-Up Instrument Questions / Answers" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentFollowUpEntry.aspx.cs" Inherits="TBI_InstrumentFollowUpEntry" MaintainScrollPositionOnPostback="true" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<%@ Register Assembly="RJS.Web.WebControl.PopCalendar.Net.2008" Namespace="RJS.Web.WebControl" TagPrefix="rjs" %>
<%@ Register Src="~/controls/FromToDate.ascx" TagName="FromToDate" TagPrefix="UserControlFromToDate" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" TagPrefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }

        .detailTable {
            border: 0px;
            background-color: #FFFFFF;
        }

            .detailTable td {
                border: 0px;
                background-color: #FFFFFF;
            }

        .requiredField {
            font-weight: bold;
            color: #FF0000;
        }

        .fixWidth tr td {
            width: 500px;
        }
    </style>

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeout="700" runat="server">
    </asp:ScriptManager>

    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);
        
        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }
            return tmr;
        }

        function StopTimer() {
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            getTimerReference()._startTimer();
        }
        
        function startRequest(sender, e) {
            StartTimer();
            //disable button during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            $('#<%= PanelQuestions.ClientID %>').hide();
        }

        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            return;
        }

        function rblMedicationReconciliationPerformed_CheckChanged() {
            var rbi1 = document.getElementById('<%=rblMedicationReconciliationPerformed.ClientID%>_0');
            var rbi2 = document.getElementById('<%=rblMedicationReconciliationPerformed.ClientID%>_1');
            var tbl1 = document.getElementById('tblMedicationGiven');
            var tbl2 = document.getElementById('tblNoMedicationReconciliationPerformed');

            if (rbi1 != null && rbi2 != null) {
                if (rbi1.checked) {
                    if (tbl1 != null) { tbl1.style.display = "inline"; }
                    if (tbl2 != null) { tbl2.style.display = "none"; }
                }
                else if (rbi2.checked) {
                    if (tbl1 != null) { tbl1.style.display = "none"; }
                    if (tbl2 != null) { tbl2.style.display = "inline"; }
                }
                else {
                    if (tbl1 != null) { tbl1.style.display = "none"; }
                    if (tbl2 != null) { tbl2.style.display = "none"; }
                }
            }
        }
    </script>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <script type="text/javascript">
            $(document).ready(function() {
                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function(e) {
                    StopTimer();
                    StartTimer();
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function(e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function(e) {
                    StopTimer();
                    StartTimer();
                });
                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function(e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function(e) {
                    return;
                }

                rblMedicationReconciliationPerformed_CheckChanged();

                // RULE 1  ***********************************************************************
                // Q4 CLICK
                $('#<%= rblExperiencedHeadInjury.ClientID %>').click(function(e) {
                    $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    if ($('#<%= rblExperiencedHeadInjury.ClientID %> input:checked').val() == '4736') { //   Q4: 4735=Yes, 4736=No
                        if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked').val() == '5044') {
                            alert("In question #19, your response indicates this patient experienced an \n" +
                             "injury.  Based on this response, this patient would not have suffered a TBI.\n\n" +
                             "If your response to question #19 is not correct, and this patient has not experienced an\n" +
                             "injury, please make the appropriate correction to question\n" +
                             "#19, and you will then be permitted to indicate the patient has suffered TBI.");

                            e.preventDefault();
                        }
                        else {
                            $('div.headInjurySection input:text').val('');
                            $('div.headInjurySection input:radio').attr('checked', false);
                            $('div.headInjurySection input:checkbox').attr('checked', false);
                            $('div.headInjurySection').hide();

                            $.each(Page_Validators, function(index, validator) {
                                if ($(validator).hasClass("headInjury")) {
                                    ValidatorEnable(validator, false);
                                }
                            });
                        }
                    }
                    else {
                        // Show 4-A
                        $('div.headInjurySection').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("headInjury")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                    }
                });

                // Part 2 of RULE 1 : When page is re-visited sans Click(), say, after a Save action
                if ($('#<%= rblExperiencedHeadInjury.ClientID %> input:checked + label').text() == 'No' || $('#<%= rblExperiencedHeadInjury.ClientID %> input:checked + label').text() == '') {
                    // Hide 4-A

                    $('div.headInjurySection input:text').val('');
                    $('div.headInjurySection input:radio').attr('checked', false);
                    $('div.headInjurySection input:checkbox').attr('checked', false);
                    $('div.headInjurySection').hide();

                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("headInjury")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 4-A
                    $('div.headInjurySection').show();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("headInjury")) {
                            ValidatorEnable(validator, true);
                        }
                    });
                }
                // END RULE 1 ***********************************************************************

                // Q5-D CLICK     ***********************************************************************
                $('#<%= rblBlastOccurrences.ClientID %>').click(function() {
                    // Enable statement below only in DEBUG mode
                    // alert('Handler for .click() called.');

                    // Enable statement below only in DEBUG mode
                    // alert($('#<%= rblBlastOccurrences.ClientID %>').find('input:checked').val());

                    if ($('#<%= rblBlastOccurrences.ClientID %> input:checked').val() == '4763') {
                        // Hide 5-D-1, 5-D-1-A, ...
                        $('div.blastSection input:text').val('');
                        $('div.blastSection input:radio').attr('checked', false);
                        $('div.blastSection input:checkbox').attr('checked', false);
                        $('div.blastSection').hide();

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("blastSection")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 5-D-1, 5-D-1-A, ...
                        $('div.blastSection').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("blastSection")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        var index = $('#<%= rblBlastOccurrences.ClientID %> input:checked').val() - 4763;
                        $('#<%= rblBlastOccurrences.ClientID %>_' + index).focus();
                    };
                });

                // Q5-D RELOAD
                if ($('#<%= rblBlastOccurrences.ClientID %> input:checked').val() == '4763' || $('#<%= rblBlastOccurrences.ClientID %> input:checked').val() == null) {
                    // Hide 5-D-1, 5-D-1-A, ...

                    $('div.blastSection').hide();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("blastSection")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 5-D-1, 5-D-1-A, ...
                    $('div.blastSection').show();
                };

                // Q6 CLICK   ***********************************************************************
                $('#<%= rblLossOfConsciousness.ClientID %>').click(function() {
                    $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    if ($('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == '4818'
                                    || $('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == '4824'
                                    || $('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == null) {
                        // Hide 6-A Panel
                        $('#<%= pnlEstimateDurationOfLossOfConsciousness.ClientID %>').hide();
                        // Uncheck 6-A Radio Button
                        $('#<%= rblDurationLossOfConsciousness.ClientID %> input:radio').attr("checked", false);
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("consciousness")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 6-A
                        //$('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                        $('#<%= pnlEstimateDurationOfLossOfConsciousness.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("consciousness")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        var index = $('#<%= rblLossOfConsciousness.ClientID %> input:checked').val();
                        $('#<%= rblLossOfConsciousness.ClientID %>_' + index).focus();
                    };
                });

                // Q6 RELOAD
                if ($('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == '4818'
                                    || $('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == '4824'
                                    || $('#<%= rblLossOfConsciousness.ClientID %> input:checked').val() == null) {
                    // Hide 6-A Panel
                    $('#<%= pnlEstimateDurationOfLossOfConsciousness.ClientID %>').hide();
                    // Uncheck 6-A Radio Button
                    $('#<%= rblDurationLossOfConsciousness.ClientID %> input:radio').attr("checked", false);
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("consciousness")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 6-A
                    $('#<%= pnlEstimateDurationOfLossOfConsciousness.ClientID %>').show();
                };

                // Q7 CLICK  ***********************************************************************
                $('#<%= rblDisorientationOrConfusion.ClientID %>').click(function() {
                    $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    if ($('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == '4833'
                                    || $('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == '5069'
                                    || $('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == null) {
                        // Hide 7-A
                        $('#<%= pnlEstimateDurationOfDisorientationOrConfusion.ClientID %>').hide();

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("confusion")) {
                                ValidatorEnable(validator, false);
                            }
                        });

                        $('#<%= rblDurationOfDisorientationOrConfusion.ClientID %> input:radio').attr("checked", false);
                    }
                    else {
                        // Show 7-A
                        $('#<%= pnlEstimateDurationOfDisorientationOrConfusion.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("confusion")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        var index = $('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val();
                        $('#<%= rblDisorientationOrConfusion.ClientID %>_' + index).focus();
                    };
                });

                // Q7 RELOAD
                if ($('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == '4833'
                                    || $('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == '5069'
                                    || $('#<%= rblDisorientationOrConfusion.ClientID %> input:checked').val() == null) {
                    // Hide 7-A
                    $('#<%= pnlEstimateDurationOfDisorientationOrConfusion.ClientID %>').hide();
                    $('#<%= rblDurationOfDisorientationOrConfusion.ClientID %> input:radio').attr("checked", false);
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("confusion")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 7-A
                    $('#<%= pnlEstimateDurationOfDisorientationOrConfusion.ClientID %>').show();
                    //$('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                };

                // Q8 CLICK  ***********************************************************************
                $('#<%= rblLossOfMemory.ClientID %>').click(function() {
                    $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    if ($('#<%= rblLossOfMemory.ClientID %> input:checked').val() == '4847'
                                    || $('#<%= rblLossOfMemory.ClientID %> input:checked').val() == '5068'
                                    || $('#<%= rblLossOfMemory.ClientID %> input:checked').val() == null) {
                        // Hide 8-A
                        $('#<%= pnlEstimateDurationOfMemoryLoss.ClientID %>').hide();
                        $('#<%= rblDurationOFMemoryLoss.ClientID  %> input:radio').attr("checked", false);

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("memory")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 8-A
                        $('#<%= pnlEstimateDurationOfMemoryLoss.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("memory")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        //$('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                        var index = $('#<%= rblLossOfMemory.ClientID %> input:checked').val();
                        $('#<%= rblLossOfMemory.ClientID %>_' + index).focus();
                    };

                });

                // Q8 RELOAD
                if ($('#<%= rblLossOfMemory.ClientID %> input:checked').val() == '4847'
                                    || $('#<%= rblLossOfMemory.ClientID %> input:checked').val() == '5068'
                                    || $('#<%= rblLossOfMemory.ClientID %> input:checked').val() == null) {

                    // Hide 8-A
                    $('#<%= pnlEstimateDurationOfMemoryLoss.ClientID %>').hide();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("memory")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 8-A
                    $('#<%= pnlEstimateDurationOfMemoryLoss.ClientID %>').show();
                    //$('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                };




                // Q10 CLICK *******************************************************************
                $('#<%= rblConsultationForNewInjury.ClientID %>').click(function() {

                    if ($('#<%= rblConsultationForNewInjury.ClientID %> input:checked').val() == '4864'
                            || $('#<%= rblConsultationForNewInjury.ClientID %> input:checked').val() == null) {
                        // Hide 10-A
                        $('#<%= pnlProviderChangesMedicationForNewInjury.ClientID %>').hide();
                        $('#<%= rblChangeMedicationForNewInjury.ClientID %> input:checked').attr("checked", false);

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("newInjury")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 10-A
                        $('#<%= pnlProviderChangesMedicationForNewInjury.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("newInjury")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        var index = $('#<%= rblConsultationForNewInjury.ClientID %> input:checked').val() - 4864;
                        $('#<%= rblConsultationForNewInjury.ClientID %>_' + index).focus();
                    };
                });
                // *************************************************************************************

                // Q10 RELOAD
                if ($('#<%= rblConsultationForNewInjury.ClientID %> input:checked').val() == '4864'
                    || $('#<%= rblConsultationForNewInjury.ClientID %> input:checked').val() == null) {

                    // Hide 10-A
                    $('#<%= pnlProviderChangesMedicationForNewInjury.ClientID %>').hide();

                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("newInjury")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 10-A
                    $('#<%= pnlProviderChangesMedicationForNewInjury.ClientID %>').show();

                };

                // Q12 CLICK
                $('#<%= rblOverallInterferenceWithLife.ClientID %>').click(function() {
                    if ($('#<%= rblOverallInterferenceWithLife.ClientID %> input:checked').val() == '5004') {

                        // Hide 12-A
                        $('#<%= pnlAreasOfLifeAffected.ClientID %>').hide();
                        $('#<%= tbxAreasOfLifeAffected.ClientID %>').val("");

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("symptoms")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 12-A
                        $('#<%= pnlAreasOfLifeAffected.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("symptoms")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                    };
                });

                // Q12 RELOAD
                if ($('#<%= rblOverallInterferenceWithLife.ClientID %> input:checked + label').text() == 'Not at all'
                             || $('#<%= rblOverallInterferenceWithLife.ClientID %> input:checked + label').text() == ''
                             || $('#<%= rblOverallInterferenceWithLife.ClientID %> input:checked + label').text() == null) {
                    // Hide 12-A
                    $('#<%= pnlAreasOfLifeAffected.ClientID %>').hide();
                    $('#<%= tbxAreasOfLifeAffected.ClientID %>').val("");
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("symptoms")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 12-A
                    $('#<%= pnlAreasOfLifeAffected.ClientID %>').show();
                };

                // Q13 CLICK
                $('#<%= rblProblemsWithPain.ClientID %>').click(function() {

                    if ($('#<%= rblProblemsWithPain.ClientID %> input:checked').val() == '5013'
                           || $('#<%= rblProblemsWithPain.ClientID %> input:checked').val() == null) {

                        $('div.painSection input:radio').removeAttr('checked');
                        $('div.painSection input:checkbox').attr('checked', false);
                        $('div.painSection').hide();

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("pain")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        $('div.painSection').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("pain")) {

                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                        $('#<%= rblProblemsWithPain.ClientID %>_1').focus();
                    };
                });

                // Q13 RELOAD
                if ($('#<%= rblProblemsWithPain.ClientID %> input:checked').val() == '5013' || $('#<%= rblProblemsWithPain.ClientID %> input:checked').val() == null) {

                    $('div.painSection').hide();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("pain")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    $('div.painSection').show();
                };

                // Q19 CLICK  : 5044=Yes, 5045=No
                $('#<%= rblExperiencedNewTbi.ClientID %>').unbind('click').click(function(e) {

                    var countYES = 0;
                    var countNO = 0;
                    $('.tbiDiagnosis input:checked').each(function() {
                        if ($(this).val() == 4819 || $(this).val() == 4820 || $(this).val() == 4821 || $(this).val() == 4822 || $(this).val() == 4823
                            || $(this).val() == 4834 || $(this).val() == 4835 || $(this).val() == 4836 || $(this).val() == 4837 || $(this).val() == 4838
                            || $(this).val() == 4848 || $(this).val() == 4849 || $(this).val() == 4850 || $(this).val() == 4851 || $(this).val() == 4852) {
                            countYES = countYES + 1;
                        }
                    });
                    $('.tbiDiagnosis input:checked').each(function() {
                        if ($(this).val() == 4818 || $(this).val() == 4824
                            || $(this).val() == 4833 || $(this).val() == 5069
                            || $(this).val() == 4847 || $(this).val() == 5068) //&& $(this).val() != 4832 && $(this).val() != 4846 && $(this).val() != 4860)                         
                        {
                            countNO = countNO + 1;
                        }
                    });

                    if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked + label').text() == 'Yes') {
                        if ($('#<%= rblExperiencedHeadInjury.ClientID %> input:checked + label').text() == 'No') {
                            alert("In question #4, your response indicates this patient did not experience an injury.\n" +
                                             "Based on this response, this patient would not have suffered a TBI.\n\n" +
                                             "If your response to question #4 is not correct, and this patient did experience an\n" +
                                             "injury, please make the appropriate correction to question#4,\n" +
                                             "and you will then be permitted to indicate the patient suffered a TBI.");
                            e.preventDefault();
                            return;
                        }
                        if (countNO == 3) { // 6,7,8 - all NO/Uncertain
                            alert("In questions 6, 7, or 8, your responses indicate this patient did not experience any of the following:\n" +
                                                    "1. Period of loss of consciousness;\n" +
                                                    "2. Loss of memory for events immediately before or after the accident;\n" +
                                                    "3. Alteration in mental state at the time of the accident (eg, feeling dazed, disoriented, or confused);\n\n" +
                                                    "Based on the VA/DoD definition for a mild TBI, these responses would indicate that this patient has not suffered a TBI.\n\n" +
                                                    "If your responses to questions 6, 7, or 8 are not correct, and this patient experienced either loss of consciousness, post traumatic amnesia " +
                                                    "or alteration of consciousness related to the injury, please make the appropriate corrections to those questions, and you will then be permitted to indicate the patient suffered a TBI following their deployment.");
                            e.preventDefault();
                            return;
                        }
                    }

                    if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked + label').text() == 'No') {
                        if (countYES > 0) { // 6,7,8 - at least one YES
                            alert("In questions 6, 7, or 8, your responses indicate this patient experienced one of the following:\n" +
                                        "1. Period of loss of consciousness;\n" +
                                        "2. Loss of memory for events immediately before or after the accident;\n" +
                                        "3. Alteration in mental state at the time of the accident (eg, feeling dazed, disoriented, or confused);\n\n" +
                                        "Based on the VA/DoD definition for a mild TBI, these responses would indicate that this patient has suffered a TBI.\n\n" +
                                        "If your responses to questions 6, 7, or 8 are not correct, and this patient did not experience either loss of consciousness, post traumatic amnesia " +
                                        "or alteration of consciousness related to the injury, please make the appropriate corrections to those questions, and you will then be permitted to indicate the patient did not suffer a TBI following their deployment.");
                            e.preventDefault();
                            return;
                        }
                    }
                });
                // *************************************************************************************

                // Q19 RELOAD **************************************************************************
                var countYES = 0;
                var countNO = 0;
                $('.tbiDiagnosis input:checked').each(function() {
                    if ($(this).val() == 4819 || $(this).val() == 4820 || $(this).val() == 4821 || $(this).val() == 4822 || $(this).val() == 4823
                            || $(this).val() == 4834 || $(this).val() == 4835 || $(this).val() == 4836 || $(this).val() == 4837 || $(this).val() == 4838
                            || $(this).val() == 4848 || $(this).val() == 4849 || $(this).val() == 4850 || $(this).val() == 4851 || $(this).val() == 4852) {
                        countYES = countYES + 1;
                    }
                });
                $('.tbiDiagnosis input:checked').each(function() {
                    if ($(this).val() == 4818 || $(this).val() == 4824
                            || $(this).val() == 4833 || $(this).val() == 5069
                            || $(this).val() == 4847 || $(this).val() == 5068) //&& $(this).val() != 4832 && $(this).val() != 4846 && $(this).val() != 4860)                         
                    {
                        countNO = countNO + 1;
                    }
                });
                if (countNO == 3) { // 6,7,8 - all NO/Uncertain
                    if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked').val() == '5044') {
                        $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    }
                }
                if (countYES > 0) {
                    if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked').val() == '5045') {
                        $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    }
                }
                if ($('#<%= rblExperiencedHeadInjury.ClientID %> input:checked').val() == '4736') {
                    if ($('#<%= rblExperiencedNewTbi.ClientID %> input:checked').val() == '5044') {
                        $('#<%= rblExperiencedNewTbi.ClientID %> input:radio').attr("checked", false);
                    }
                }

                if ($('#<%= RadioButtonListClinicalJudgement.ClientID %> input:checked').val() != '5051') {
                    $('#<%= PanelOtherCondition.ClientID %>').hide();
                    $('#<%= PanelOtherCondition.ClientID %> input:text').val('');
                    $('#<%= PanelOtherCondition.ClientID %> textarea').val('');

                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("judgement")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    // Show 19-A-1
                    $('#<%= PanelOtherCondition.ClientID %>').show();
                }
                // *************************************************************************************

                //19-A-1
                $('#<%= RadioButtonListClinicalJudgement.ClientID %>').click(function() {
                    if ($('#<%= RadioButtonListClinicalJudgement.ClientID %> input:checked').val() != '5051') {
                        $('#<%= PanelOtherCondition.ClientID %>').hide();
                        $('#<%= PanelOtherCondition.ClientID %> input:text').val('');
                        $('#<%= PanelOtherCondition.ClientID %> textarea').val('');

                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("judgement")) {
                                ValidatorEnable(validator, false);
                            }
                        });
                    }
                    else {
                        // Show 19-A
                        $('#<%= PanelOtherCondition.ClientID %>').show();
                        $.each(Page_Validators, function(index, validator) {
                            if ($(validator).hasClass("judgement")) {
                                ValidatorEnable(validator, true);
                                validator.isvalid = true;
                                ValidatorUpdateDisplay(validator);
                            }
                        });
                    }
                });

                //13
                if ($('#<%= rblProblemsWithPain.ClientID %> input:checked + label').text() == 'No' || $('#<%= rblProblemsWithPain.ClientID %> input:checked + label').text() == '') {
                    $('div.painSection').hide();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("pain")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    $('div.painSection').show();
                    $.each(Page_Validators, function(index, validator) {
                        if ($(validator).hasClass("pain")) {
                            ValidatorEnable(validator, true);
                        }
                    });
                };

            $('div.medSection').hide();
            $('div.medSection2').hide();
            });                                                                                                    
            // END $(document).ready(function()
            
            function checkPainListValidate(sender, args) {
                args.IsValid = true;

                if ($('#<%= cblProblemsWithPain.ClientID %> input:checked').length > 0)
                    args.IsValid = true;

                else
                    args.IsValid = false;
            }

            function checkBlastExposuresTypesValidate(sender, args) {
                args.IsValid = true;

                if ($('#<%= CheckBoxListTypeOfBlastExposures.ClientID %> input:checked').length > 0)
                    args.IsValid = true;

                else
                    args.IsValid = false;
            }

            function checkHeadInjuryMonthValidate(sender, args) {
                var injYear = $('#<%= tbxYearOfRecentHeadInjury.ClientID %>').val();
                var injMonth = $('#<%= tbxMonthOfRecentHeadInjury.ClientID %>').val();

                var value = Number(injMonth);

                if (Math.floor(value) != value) {
                    args.IsValid = false;
                    return;
                }
                else {

                    if (value < 1 || value > 12) {

                        args.IsValid = false;
                        return;
                    }
                    else {
                        // month is an integer, do something based on that
                        var currMonth = new Date().getMonth() + 1;
                        var currYear = new Date().getFullYear();

                        if (injYear == currYear && injMonth > currMonth) {
                            //future month
                            args.IsValid = false;
                        }
                        else {
                            //past or present month
                            args.IsValid = true;
                        }
                    }
                }
            }

            function btnSaveButtonChange_Click() 
            {
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > TBI FOLLOW-UP ASSESSMENT"></asp:Label>
        </div>
    </telerik:RadCodeBlock>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock4">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>

                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server"
                    TabIndex="1"
                    HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList"
                    ShowSummary="false"
                    ShowMessageBox="true"
                    ValidationGroup="OnSave" />

                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>&nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="COMP TBI FOLLOW-UP" />
                <!-- Panel Questions -->
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <table id="Table1" cellpadding="5" cellspacing="5" width="100%" runat="server">
                        <tr id="TrQA">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="LabelforTextBoxChiefComplaint" AssociatedControlID="TextBoxChiefComplaint" runat="server" CssClass="firstLevelQuestion">
                                    A. Chief Complaint:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="TextBoxChiefComplaint" runat="server"
                                                    TextMode="MultiLine" Rows="5" Width="100%" />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQB">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="LabelforTextBoxHistoryPresentIllness" AssociatedControlID="TextBoxHistoryPresentIllness" runat="server" CssClass="firstLevelQuestion">
                                    B. History of Present Illness, or Interval History since last visit:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="TextBoxHistoryPresentIllness" runat="server"
                                                    TextMode="MultiLine" Rows="5" Width="100%" />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ1">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="Q1Label" AssociatedControlID="RadioButtonListChangeInMaritalStatus" runat="server" CssClass="firstLevelQuestion">
                                1. Change in Marital Status:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:RadioButtonList ID="RadioButtonListChangeInMaritalStatus"
                                                    OnDataBound="RadioButtonList_Common_OnDataBound"
                                                    runat="server"
                                                    RepeatDirection="Vertical"
                                                    DataSourceID="ObjectDataSourceQ1"
                                                    TabIndex="6"
                                                    DataTextField="CHOICE_TEXT"
                                                    DataValueField="STD_QUESTION_CHOICE_ID"
                                                    CssClass="fixWidth">
                                                </asp:RadioButtonList>
                                                <!--Question 1 Required Validator-->
                                                <asp:RequiredFieldValidator ID="MaritalStatusValidator"
                                                    ControlToValidate="RadioButtonListChangeInMaritalStatus"
                                                    Display="Dynamic"
                                                    runat="server"
                                                    EnableClientScript="true"
                                                    ErrorMessage="Change in Marital Status is required."
                                                    SetFocusOnError="true"
                                                    ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                </asp:RequiredFieldValidator>
                                                <!--Question 1 Object Data Source-->
                                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server"
                                                    SelectMethod="GetQuestionChoices"
                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <!--Question 1 : Question Number-->
                                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ2">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="Q2Label" AssociatedControlID="RadioButtonListHighestEducationalLevel" runat="server" CssClass="firstLevelQuestion">
                                    2. Highest educational level achieved:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:RadioButtonList ID="RadioButtonListHighestEducationalLevel"
                                                    runat="server"
                                                    OnDataBound="RadioButtonList_Common_OnDataBound"
                                                    RepeatDirection="Vertical"
                                                    DataSourceID="ObjectDataSourceQ2"
                                                    TabIndex="8"
                                                    DataTextField="CHOICE_TEXT"
                                                    DataValueField="STD_QUESTION_CHOICE_ID"
                                                    CssClass="fixWidth">
                                                </asp:RadioButtonList>
                                                <!--Question 2 Required Validator-->
                                                <asp:RequiredFieldValidator ID="EducationalLevelValidator"
                                                    ControlToValidate="RadioButtonListHighestEducationalLevel"
                                                    Display="Dynamic"
                                                    runat="server"
                                                    EnableClientScript="true"
                                                    ErrorMessage="Highest educational level achieved is required."
                                                    SetFocusOnError="true"
                                                    ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                </asp:RequiredFieldValidator>
                                                <!--Question 2 Object Data Source-->
                                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server"
                                                    SelectMethod="GetQuestionChoices"
                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">

                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <!--Question 2 : Question Number-->
                                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                                            </td>
                                        </tr>
                                        <tr id="TrQ2A">
                                            <td>
                                                <fieldset class="firstLevelAnswer">
                                                    <table width="100%">
                                                        <tr class="subquestionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="Q2ALabel" AssociatedControlID="RadioButtonListCurrentSchool" runat="server" CssClass="firstLevelQuestion">
                                            2-A. Current school or training status:
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:RadioButtonList ID="RadioButtonListCurrentSchool"
                                                                    runat="server"
                                                                    OnDataBound="RadioButtonList_Common_OnDataBound"
                                                                    RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2A"
                                                                    TabIndex="10"
                                                                    DataTextField="CHOICE_TEXT"
                                                                    DataValueField="STD_QUESTION_CHOICE_ID">
                                                                </asp:RadioButtonList>
                                                                <!--Question 2a Required Validator-->
                                                                <asp:RequiredFieldValidator ID="CurrentSchoolValidator"
                                                                    ControlToValidate="RadioButtonListCurrentSchool"
                                                                    Display="Dynamic"
                                                                    runat="server"
                                                                    EnableClientScript="true"
                                                                    ErrorMessage="Current school or training status is required."
                                                                    SetFocusOnError="true"
                                                                    ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                </asp:RequiredFieldValidator>
                                                                <!--Question 2a Object Data Source-->
                                                                <asp:ObjectDataSource ID="ObjectDataSourceQ2A" runat="server"
                                                                    SelectMethod="GetQuestionChoices"
                                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">

                                                                    <SelectParameters>
                                                                        <asp:ControlParameter ControlID="HiddenQ2A" Direction="Input" Name="questionNumber" Type="String" />
                                                                    </SelectParameters>
                                                                </asp:ObjectDataSource>
                                                                <!--Question 2a : Question Number-->
                                                                <asp:HiddenField ID="HiddenQ2A" runat="server" Visible="false" Value="2-A" />
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </fieldset>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ3">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="Q3Label" AssociatedControlID="RadioButtonListCurrentEmploymentStatus" runat="server" CssClass="firstLevelQuestion">
                                    3. Current employment status:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:RadioButtonList ID="RadioButtonListCurrentEmploymentStatus"
                                                    runat="server"
                                                    OnDataBound="RadioButtonList_Common_OnDataBound"
                                                    RepeatDirection="Horizontal"
                                                    RepeatColumns="2"
                                                    RepeatLayout="Table"
                                                    CssClass="fixWidth"
                                                    DataSourceID="ObjectDataSourceQ3"
                                                    TabIndex="12"
                                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                                </asp:RadioButtonList>
                                                <!--Question 3 Required Validator-->
                                                <asp:RequiredFieldValidator ID="EmploymentStatusValidator"
                                                    ControlToValidate="RadioButtonListCurrentEmploymentStatus"
                                                    Display="Dynamic"
                                                    runat="server"
                                                    EnableClientScript="true"
                                                    ErrorMessage="Current employment status is required."
                                                    SetFocusOnError="true"
                                                    ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                </asp:RequiredFieldValidator>
                                                <!--Question 3 Object Data Source-->
                                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server"
                                                    SelectMethod="GetQuestionChoices"
                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <!--Question 3 : Question Number-->
                                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrChI">
                            <td>
                                <br />
                                <asp:Label ID="lblSectionInjury" runat="server" Text="I. Injury" Font-Bold="true" />
                            </td>
                        </tr>
                        <tr id="TrQ4">
                            <td>
                                <asp:Panel ID="pnlExperiencedHeadInjury" Width="100%" runat="server">
                                    <fieldset>
                                        <table width="100%" cellpadding="5" cellspacing="5">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q4Label" AssociatedControlID="rblExperiencedHeadInjury" runat="server" CssClass="firstLevelQuestion">
                                    4. Experienced head injury since prior evaluation?
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="rblExperiencedHeadInjury"
                                                        runat="server"
                                                        OnDataBound="RadioButtonList_Common_OnDataBound"
                                                        DataSourceID="ObjectDataSourceQ4"
                                                        TabIndex="15"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        RepeatDirection="Vertical"
                                                        RepeatColumns="2"
                                                        RepeatLayout="Table"
                                                        CssClass="fixWidth">
                                                    </asp:RadioButtonList>
                                                    <!--Question 4 Required Validator-->
                                                    <asp:RequiredFieldValidator ID="PriorHeadInjuryValidator"
                                                        ControlToValidate="rblExperiencedHeadInjury"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Experienced head injury since prior evaluation is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                    </asp:RequiredFieldValidator>
                                                    <!--Question 4 Object Data Source-->
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <!--Question 4 : Question Number-->
                                                    <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="headInjurySection" style="padding-left: 10pt">
                                                        <table>
                                                            <tr>
                                                                <td width="22%">
                                                                    <asp:Label ID="lblMonthOfRecentHeadInjury" runat="server"
                                                                        AssociatedControlID="tbxMonthOfRecentHeadInjury">
                                                    4-A. Month of most recent head injury:
                                                                    </asp:Label>
                                                                </td>
                                                                <td>
                                                                    <asp:TextBox ID="tbxMonthOfRecentHeadInjury" TabIndex="17" runat="server" Width="75px"></asp:TextBox>
                                                                    <asp:RangeValidator ID="RecentInjuryMonthRangeValidator" runat="server" ControlToValidate="tbxMonthOfRecentHeadInjury"
                                                                        EnableClientScript="true" SetFocusOnError="true" Display="Dynamic" MinimumValue="1" MaximumValue="12"
                                                                        ErrorMessage="Recent injury month needs to be a valid month." Type="Integer" ValidationGroup="OnSave"></asp:RangeValidator>
                                                                    <asp:CustomValidator ID="HeadInjuryCustomValidator" runat="server" EnableClientScript="true" SetFocusOnError="true"
                                                                        Display="Dynamic" ValidationGroup="OnSave" ErrorMessage="Head injury month needs to be a valid month and should be in the past."
                                                                        ClientValidationFunction="checkHeadInjuryMonthValidate" ControlToValidate="tbxMonthOfRecentHeadInjury"></asp:CustomValidator>
                                                                    <asp:HiddenField ID="Hidden4A" runat="server" Visible="false" Value="4-A" />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td width="22%">
                                                                    <asp:Label ID="lblYearOfRecentHeadInjury" runat="server"
                                                                        AssociatedControlID="tbxYearOfRecentHeadInjury">
                                                    4-B. Year of most recent head injury:
                                                                    </asp:Label>
                                                                </td>
                                                                <td>
                                                                    <asp:TextBox ID="tbxYearOfRecentHeadInjury" runat="server" Width="75px" TabIndex="18"> 
                                                                    </asp:TextBox>

                                                                    <asp:RangeValidator ID="InjuryYearRangeValidator" runat="server" ControlToValidate="tbxYearOfRecentHeadInjury"
                                                                        EnableClientScript="true" SetFocusOnError="true" Display="Dynamic" ValidationGroup="OnSave"
                                                                        ErrorMessage="Head injury year needs to be a valid year between 2001 and current date." Type="Integer" CssClass="injuriesnone"></asp:RangeValidator>

                                                                    <%--                                                <asp:CustomValidator ID = "InjuryYearRangeValidator" runat = "server" EnableClientScript = "true" SetFocusOnError = "true" 
                                                    Display = "Dynamic" ValidationGroup = "OnSave" ErrorMessage = "Head injury year needs to be a valid year between 2001 and current date."
                                                    ClientValidationFunction = "checkHeadInjuryYearValidate" ControlToValidate = "tbxYearOfRecentHeadInjury">
                                                </asp:CustomValidator>  --%>

                                                                    <asp:RequiredFieldValidator ID="RecentInjuryYearValidator"
                                                                        ControlToValidate="tbxYearOfRecentHeadInjury"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Year of most recent head injury is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <asp:HiddenField ID="Hidden4B" runat="server" Visible="false" Value="4-B" />
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="headInjurySection">
                                    <table width="100%">
                                        <tr id="TrQ5">
                                            <td>
                                                <fieldset>
                                                    <table width="100%" cellpadding="5" cellspacing="5">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="lblCauseOfInjurySection" runat="server" Font-Bold="true" CssClass="firstLevelQuestion">
                                            5. Cause Of Injury
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ5A">
                                                            <td>
                                                                <asp:Panel ID="pnlBullet" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q5ALabel" AssociatedControlID="rblBullet" runat="server" CssClass="firstLevelQuestion">
                                                        5-A. Bullet
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblBullet"
                                                                                        runat="server"
                                                                                        RepeatDirection="Horizontal"
                                                                                        DataSourceID="ObjectDataSourceQ5A"
                                                                                        TabIndex="19"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 5A Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="BulletEpisodesValidator"
                                                                                        ControlToValidate="rblBullet"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Bullet episodes number is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 5A Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5A" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ5A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 5A : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ5A" runat="server" Visible="false" Value="5-A" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ5B">
                                                            <td>
                                                                <asp:Panel ID="pnlVehicular" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q5BLabel" AssociatedControlID="rblVehicular" runat="server" CssClass="firstLevelQuestion">
                                                        5-B. Vehicular
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblVehicular"
                                                                                        runat="server"
                                                                                        DataSourceID="ObjectDataSourceQ5B"
                                                                                        TabIndex="21"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatDirection="Horizontal"
                                                                                        RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 5B Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="VehicularEpisodesValidator"
                                                                                        ControlToValidate="rblVehicular"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Vehicular episodes number is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 5B Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5B" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ5B" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 5B : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ5B" runat="server" Visible="false" Value="5-B" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ5C">
                                                            <td>
                                                                <asp:Panel ID="pnlFall" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q5CLabel" AssociatedControlID="rblFall" runat="server" CssClass="firstLevelQuestion">
                                                        5-C. Fall
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblFall"
                                                                                        runat="server"
                                                                                        DataSourceID="ObjectDataSourceQ5C"
                                                                                        TabIndex="23"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatDirection="Horizontal"
                                                                                        RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 5C Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="FallEpisodesValidator"
                                                                                        ControlToValidate="rblFall"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Fall episodes number is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 5C Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5C" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ5C" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 5C : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ5C" runat="server" Visible="false" Value="5-C" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                    <br />
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ5D">
                                                            <td>
                                                                <asp:Panel ID="pnlBlast" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q5DLabel" AssociatedControlID="rblBlastOccurrences" runat="server" CssClass="firstLevelQuestion">
                                                        5-D. Blast
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblBlastOccurrences"
                                                                                        runat="server"
                                                                                        DataSourceID="ObjectDataSourceQ5D"
                                                                                        TabIndex="25"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatDirection="Horizontal"
                                                                                        RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 5D Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="BlastOccurrencesValidator"
                                                                                        ControlToValidate="rblBlastOccurrences"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Blast Occurrences number is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 5D Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5D" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ5D" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 5D : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ5D" runat="server" Visible="false" Value="5-D" />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="blastSection">
                                                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                                                            <tr id="TrQ5D1">
                                                                                                <td>
                                                                                                    <asp:Panel ID="pnlBlastWaveExperience" Width="100%" runat="server">
                                                                                                        <fieldset class="secondLevelQuestion">
                                                                                                            <table width="100%">
                                                                                                                <tr class="questionBackgroundColor">
                                                                                                                    <td>
                                                                                                                        <asp:Label ID="Q5D1Label" AssociatedControlID="rblBlastWaveExperience" runat="server" CssClass="firstLevelQuestion">
                                                                                5-D-1. When a high-explosive bomb or IED goes off there is a &quot;blast wave&quot; which is a wave of highly compressed gas that may feel almost like being smashed into a wall. Do you remember experiencing this or were told that you experienced it?
                                                                                                                        </asp:Label>
                                                                                                                        <br />
                                                                                                                        <br />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr>
                                                                                                                    <td>
                                                                                                                        <asp:RadioButtonList ID="rblBlastWaveExperience"
                                                                                                                            runat="server"
                                                                                                                            DataSourceID="ObjectDataSourceQ5D1"
                                                                                                                            TabIndex="27"
                                                                                                                            DataTextField="CHOICE_TEXT"
                                                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                            RepeatDirection="Horizontal"
                                                                                                                            RepeatColumns="2"
                                                                                                                            RepeatLayout="Table"
                                                                                                                            CssClass="fixWidth"
                                                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                                                        </asp:RadioButtonList>
                                                                                                                        <!--Question 5D1 Required Validator-->
                                                                                                                        <asp:RequiredFieldValidator ID="BlastWaveExperienceValidator"
                                                                                                                            ControlToValidate="rblBlastWaveExperience"
                                                                                                                            Display="Dynamic"
                                                                                                                            runat="server"
                                                                                                                            EnableClientScript="true"
                                                                                                                            ErrorMessage="Blast Wave Experience episodes number is required."
                                                                                                                            SetFocusOnError="true"
                                                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury blastSection">
                                                                                                                        </asp:RequiredFieldValidator>
                                                                                                                        <!--Question 5D1 Object Data Source-->
                                                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5D1" runat="server"
                                                                                                                            SelectMethod="GetQuestionChoices"
                                                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                            <SelectParameters>
                                                                                                                                <asp:ControlParameter ControlID="HiddenQ5D1" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                            </SelectParameters>
                                                                                                                        </asp:ObjectDataSource>
                                                                                                                        <!--Question 5D1 : Question Number-->
                                                                                                                        <asp:HiddenField ID="HiddenQ5D1" runat="server" Visible="false" Value="5-D-1" />

                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr id="TrQ5D1A">
                                                                                                                    <td>
                                                                                                                        <asp:Panel ID="pnlEstimatedBlastDistance" Width="100%" runat="server">
                                                                                                                            <fieldset class="secondLevelAnswer">
                                                                                                                                <table width="100%">
                                                                                                                                    <tr class="subquestionBackgroundColor">
                                                                                                                                        <td>
                                                                                                                                            <asp:Label ID="Q5D1ALabel" AssociatedControlID="rblEstimatedBlastDistance" runat="server" CssClass="firstLevelQuestion">
                                                                                                    5-D-1-a. Estimated distance from closest blast:
                                                                                                                                            </asp:Label>
                                                                                                                                            <br />
                                                                                                                                            <br />
                                                                                                                                        </td>
                                                                                                                                    </tr>
                                                                                                                                    <tr>
                                                                                                                                        <td>
                                                                                                                                            <asp:RadioButtonList ID="rblEstimatedBlastDistance"
                                                                                                                                                runat="server"
                                                                                                                                                DataSourceID="ObjectDataSourceQ5D1A"
                                                                                                                                                TabIndex="29"
                                                                                                                                                DataTextField="CHOICE_TEXT"
                                                                                                                                                DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                                                RepeatDirection="Horizontal"
                                                                                                                                                RepeatColumns="2"
                                                                                                                                                RepeatLayout="Table"
                                                                                                                                                CssClass="fixWidth"
                                                                                                                                                OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                                                                            </asp:RadioButtonList>
                                                                                                                                            <!--Question 5D1A Required Validator-->
                                                                                                                                            <asp:RequiredFieldValidator ID="BlastDistanceValidator"
                                                                                                                                                ControlToValidate="rblEstimatedBlastDistance"
                                                                                                                                                Display="Dynamic"
                                                                                                                                                runat="server"
                                                                                                                                                EnableClientScript="true"
                                                                                                                                                ErrorMessage="Estimated distance from closest blast is required."
                                                                                                                                                SetFocusOnError="true"
                                                                                                                                                ValidationGroup="OnSave" CssClass="ValidatorClass headInjury blastSection">
                                                                                                                                            </asp:RequiredFieldValidator>
                                                                                                                                            <!--Question 5D1A Object Data Source-->
                                                                                                                                            <asp:ObjectDataSource ID="ObjectDataSourceQ5D1A" runat="server"
                                                                                                                                                SelectMethod="GetQuestionChoices"
                                                                                                                                                TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                                                <SelectParameters>
                                                                                                                                                    <asp:ControlParameter ControlID="HiddenQ5D1A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                                                </SelectParameters>
                                                                                                                                            </asp:ObjectDataSource>
                                                                                                                                            <!--Question 5D1A : Question Number-->
                                                                                                                                            <asp:HiddenField ID="HiddenQ5D1A" runat="server" Visible="false" Value="5-D-1-A" />
                                                                                                                                        </td>
                                                                                                                                    </tr>
                                                                                                                                </table>
                                                                                                                            </fieldset>
                                                                                                                        </asp:Panel>
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            </table>
                                                                                                        </fieldset>
                                                                                                    </asp:Panel>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr id="TrQ5D2">
                                                                                                <td>
                                                                                                    <asp:Panel ID="pnlBlastWaveWindExperience" Width="100%" runat="server">
                                                                                                        <fieldset class="secondLevelQuestion">
                                                                                                            <table width="100%">
                                                                                                                <tr class="questionBackgroundColor">
                                                                                                                    <td>
                                                                                                                        <asp:Label ID="Q5D2Label" AssociatedControlID="rblBlastWaveWindExperience" runat="server" CssClass="firstLevelQuestion">
                                                                                5-D-2. This "blast wave" is followed by a wind in which particles of sand, debris, shrapnel, and fragments are moving rapidly. Were you close enough to the blast to be "peppered" or hit by such debris,  shrapnel, or other items?
                                                                                                                        </asp:Label>
                                                                                                                        <br />
                                                                                                                        <br />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr>
                                                                                                                    <td>
                                                                                                                        <asp:RadioButtonList ID="rblBlastWaveWindExperience"
                                                                                                                            runat="server"
                                                                                                                            DataSourceID="ObjectDataSourceQ5D2"
                                                                                                                            TabIndex="31"
                                                                                                                            DataTextField="CHOICE_TEXT"
                                                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                            RepeatDirection="Horizontal"
                                                                                                                            RepeatColumns="2"
                                                                                                                            RepeatLayout="Table"
                                                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound"
                                                                                                                            CssClass="fixWidth">
                                                                                                                        </asp:RadioButtonList>
                                                                                                                        <!--Question 5D2 Required Validator-->
                                                                                                                        <asp:RequiredFieldValidator ID="BlastWaveWindValidator"
                                                                                                                            ControlToValidate="rblBlastWaveWindExperience"
                                                                                                                            Display="Dynamic"
                                                                                                                            runat="server"
                                                                                                                            EnableClientScript="true"
                                                                                                                            ErrorMessage="Blast Wave Wind Experience episodes number is required."
                                                                                                                            SetFocusOnError="true"
                                                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury blastSection">
                                                                                                                        </asp:RequiredFieldValidator>
                                                                                                                        <!--Question 5D2 Object Data Source-->
                                                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5D2" runat="server"
                                                                                                                            SelectMethod="GetQuestionChoices"
                                                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                            <SelectParameters>
                                                                                                                                <asp:ControlParameter ControlID="HiddenQ5D2" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                            </SelectParameters>
                                                                                                                        </asp:ObjectDataSource>
                                                                                                                        <!--Question 5D2 : Question Number-->
                                                                                                                        <asp:HiddenField ID="HiddenQ5D2" runat="server" Visible="false" Value="5-D-2" />

                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            </table>
                                                                                                        </fieldset>
                                                                                                    </asp:Panel>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr id="TrQ5D3">
                                                                                                <td>
                                                                                                    <asp:Panel ID="pnlBlastWaveCausingViolentImpact" Width="100%" runat="server">
                                                                                                        <fieldset class="secondLevelQuestion">
                                                                                                            <table width="100%">
                                                                                                                <tr class="questionBackgroundColor">
                                                                                                                    <td>
                                                                                                                        <asp:Label ID="Q5D3Label" AssociatedControlID="rblBlastWaveCausingViolentImpact" runat="server" CssClass="firstLevelQuestion">
                                                                                5-D-3. Were you thrown to the ground or against some stationary object like a wall, vehicle or inside a vehicle by the explosion? (This is not asking if you ducked to the ground to protect yourself.)
                                                                                                                        </asp:Label>
                                                                                                                        <br />
                                                                                                                        <br />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr>
                                                                                                                    <td>
                                                                                                                        <asp:RadioButtonList ID="rblBlastWaveCausingViolentImpact"
                                                                                                                            runat="server"
                                                                                                                            DataSourceID="ObjectDataSourceQ5D3"
                                                                                                                            TabIndex="33"
                                                                                                                            DataTextField="CHOICE_TEXT"
                                                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                            RepeatDirection="Horizontal"
                                                                                                                            RepeatColumns="2"
                                                                                                                            RepeatLayout="Table"
                                                                                                                            CssClass="fixWidth"
                                                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                                                        </asp:RadioButtonList>
                                                                                                                        <!--Question 5D3 Required Validator-->
                                                                                                                        <asp:RequiredFieldValidator ID="RequiredFieldValidator4"
                                                                                                                            ControlToValidate="rblBlastWaveCausingViolentImpact"
                                                                                                                            Display="Dynamic"
                                                                                                                            runat="server"
                                                                                                                            EnableClientScript="true"
                                                                                                                            ErrorMessage="Blast Wave Causing Violent Impact episodes number is required."
                                                                                                                            SetFocusOnError="true"
                                                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury blastSection">
                                                                                                                        </asp:RequiredFieldValidator>
                                                                                                                        <!--Question 5D3 Object Data Source-->
                                                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5D3" runat="server"
                                                                                                                            SelectMethod="GetQuestionChoices"
                                                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                            <SelectParameters>
                                                                                                                                <asp:ControlParameter ControlID="HiddenQ5D3" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                            </SelectParameters>
                                                                                                                        </asp:ObjectDataSource>
                                                                                                                        <!--Question 5D3 : Question Number-->
                                                                                                                        <asp:HiddenField ID="HiddenQ5D3" runat="server" Visible="false" Value="5-D-3" />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            </table>
                                                                                                        </fieldset>
                                                                                                    </asp:Panel>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr id="TrQ5D4">
                                                                                                <td>
                                                                                                    <asp:Panel ID="pnlBlastExplosionCausingInjuries" Width="100%" runat="server">
                                                                                                        <fieldset class="secondLevelQuestion">
                                                                                                            <table width="100%">
                                                                                                                <tr class="questionBackgroundColor">
                                                                                                                    <td>
                                                                                                                        <asp:Label ID="Q5D4Label" AssociatedControlID="rblBlastExplosionCausingInjuries" runat="server" CssClass="firstLevelQuestion">
                                                                                5-D-4. Did you experience any of the following injuries as a result of an explosive blast: burns, wounds, broken bones, amputations, breathing toxic fumes, or crush injuries from structures falling onto you?
                                                                                                                        </asp:Label>
                                                                                                                        <br />
                                                                                                                        <br />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr>
                                                                                                                    <td>
                                                                                                                        <asp:RadioButtonList ID="rblBlastExplosionCausingInjuries"
                                                                                                                            runat="server"
                                                                                                                            DataSourceID="ObjectDataSourceQ5D4"
                                                                                                                            TabIndex="35"
                                                                                                                            DataTextField="CHOICE_TEXT"
                                                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                            RepeatDirection="Horizontal"
                                                                                                                            RepeatColumns="2"
                                                                                                                            RepeatLayout="Table"
                                                                                                                            CssClass="fixWidth"
                                                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                                                        </asp:RadioButtonList>
                                                                                                                        <!--Question 5d4 Required Validator-->
                                                                                                                        <asp:RequiredFieldValidator ID="BlastExplosionInjuriesValidator"
                                                                                                                            ControlToValidate="rblBlastExplosionCausingInjuries"
                                                                                                                            Display="Dynamic"
                                                                                                                            runat="server"
                                                                                                                            EnableClientScript="true"
                                                                                                                            ErrorMessage="Blast Explosion Causing Injuries episodes number is required."
                                                                                                                            SetFocusOnError="true"
                                                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury blastSection">
                                                                                                                        </asp:RequiredFieldValidator>
                                                                                                                        <!--Question 5d4 Object Data Source-->
                                                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5D4" runat="server"
                                                                                                                            SelectMethod="GetQuestionChoices"
                                                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                            <SelectParameters>
                                                                                                                                <asp:ControlParameter ControlID="HiddenQ5D4" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                            </SelectParameters>
                                                                                                                        </asp:ObjectDataSource>
                                                                                                                        <!--Question 5d4 : Question Number-->
                                                                                                                        <asp:HiddenField ID="HiddenQ5D4" runat="server" Visible="false" Value="5-D-4" />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            </table>
                                                                                                        </fieldset>
                                                                                                    </asp:Panel>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr id="TrQ5D5">
                                                                                                <td>
                                                                                                    <asp:Panel ID="pnlTypeOfBlastExposures" Width="100%" runat="server">
                                                                                                        <fieldset class="secondLevelQuestion">
                                                                                                            <table width="100%">
                                                                                                                <tr class="questionBackgroundColor">
                                                                                                                    <td>
                                                                                                                        <asp:Label ID="Q5D5Label" AssociatedControlID="CheckBoxListTypeOfBlastExposures" runat="server" CssClass="firstLevelQuestion">
                                                                            5-D-5. Type of Blast Exposures (Check all that apply):
                                                                                                                        </asp:Label>
                                                                                                                        <br />
                                                                                                                        <br />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                                <tr>
                                                                                                                    <td>
                                                                                                                        <asp:CheckBoxList ID="CheckBoxListTypeOfBlastExposures"
                                                                                                                            runat="server"
                                                                                                                            DataSourceID="ObjectDataSourceQ5D5"
                                                                                                                            TabIndex="37"
                                                                                                                            DataTextField="CHOICE_TEXT"
                                                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                                                            RepeatDirection="Horizontal"
                                                                                                                            RepeatColumns="2"
                                                                                                                            RepeatLayout="Table"
                                                                                                                            CssClass="fixWidth"
                                                                                                                            OnDataBound="CheckBoxListTypeOfBlastExposures_OnDataBound">
                                                                                                                        </asp:CheckBoxList>
                                                                                                                        <web:RequiredFieldValidatorForCheckBoxLists ID="TypeofBlastExposuresValidator"
                                                                                                                            ControlToValidate="CheckBoxListTypeOfBlastExposures"
                                                                                                                            Display="Dynamic"
                                                                                                                            runat="server"
                                                                                                                            EnableClientScript="true"
                                                                                                                            ErrorMessage="Type of blast explosures is required."
                                                                                                                            SetFocusOnError="true"
                                                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass injuriesnone headInjury blastSection">
                                                                                                                        </web:RequiredFieldValidatorForCheckBoxLists>
                                                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5D5" runat="server"
                                                                                                                            SelectMethod="GetQuestionChoices"
                                                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                                                            <SelectParameters>
                                                                                                                                <asp:ControlParameter ControlID="HiddenQ5D5" Direction="Input" Name="questionNumber" Type="String" />
                                                                                                                            </SelectParameters>
                                                                                                                        </asp:ObjectDataSource>
                                                                                                                        <!--Question 5D5 : Question Number-->
                                                                                                                        <asp:HiddenField ID="HiddenQ5D5" runat="server" Visible="false" Value="5-D-5" />
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            </table>
                                                                                                        </fieldset>
                                                                                                    </asp:Panel>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </table>
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ5E">
                                                            <td>
                                                                <asp:Panel ID="pnlBluntTraumaOtherThanFromBlast" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q5ELabel" AssociatedControlID="rblBluntTraumaOtherThanFromBlast" runat="server" CssClass="firstLevelQuestion">
                                                        5-E. Blunt trauma other than from blast/vehicular injury, e.g., assault, blunt force, sports related or object hitting head:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblBluntTraumaOtherThanFromBlast"
                                                                                        runat="server"
                                                                                        DataSourceID="ObjectDataSourceQ5E"
                                                                                        TabIndex="39"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatDirection="Horizontal"
                                                                                        RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 5E Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="BluntTraumaValidator"
                                                                                        ControlToValidate="rblBluntTraumaOtherThanFromBlast"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Blunt trauma other than from blast/vehicular injury episodes number is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 5E Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5E" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ5E" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 5E : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ5E" runat="server" Visible="false" Value="5-E" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                    <br />
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </fieldset>
                                            </td>
                                        </tr>

                                        <tr id="TrQ6">
                                            <td>
                                                <asp:Panel ID="pnlLossOfConsciousness" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q6Label" AssociatedControlID="rblLossOfConsciousness" runat="server" CssClass="firstLevelQuestion">
                                            6. Did you lose consciousness immediately after any of these experiences?
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:RadioButtonList ID="rblLossOfConsciousness"
                                                                        runat="server"
                                                                        DataSourceID="ObjectDataSourceQ6"
                                                                        TabIndex="41"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        RepeatDirection="Horizontal"
                                                                        RepeatColumns="2"
                                                                        RepeatLayout="Table"
                                                                        CssClass="fixWidth tbiDiagnosis"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 6 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="ConsciousnessRequiredFieldValidator"
                                                                        ControlToValidate="rblLossOfConsciousness"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Lose consciousness immediately after any of these experiences is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 6 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 6 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                                                                </td>
                                                            </tr>
                                                            <tr id="TrQ6A">
                                                                <td>
                                                                    <asp:Panel ID="pnlEstimateDurationOfLossOfConsciousness" Width="100%" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q6ALabel" AssociatedControlID="rblDurationLossOfConsciousness" runat="server" CssClass="firstLevelQuestion">
                                                            6-A. If yes, estimate the duration of longest period of loss of consciousness
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:RadioButtonList ID="rblDurationLossOfConsciousness"
                                                                                            runat="server"
                                                                                            DataSourceID="ObjectDataSourceQ6A"
                                                                                            TabIndex="43"
                                                                                            DataTextField="CHOICE_TEXT"
                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                            RepeatDirection="Horizontal"
                                                                                            RepeatColumns="2"
                                                                                            RepeatLayout="Table"
                                                                                            CssClass="fixWidth"
                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound"
                                                                                            EnableViewState="false">
                                                                                        </asp:RadioButtonList>
                                                                                        <!--Question 6A Required Validator-->
                                                                                        <asp:RequiredFieldValidator ID="DurationRequiredFieldValidator"
                                                                                            ControlToValidate="rblDurationLossOfConsciousness"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="Duration of loss of consciousness is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury consciousness">
                                                                                        </asp:RequiredFieldValidator>
                                                                                        <!--Question 6A Object Data Source-->
                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ6A" runat="server"
                                                                                            SelectMethod="GetQuestionChoices"
                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                            <SelectParameters>
                                                                                                <asp:ControlParameter ControlID="HiddenQ6A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                            </SelectParameters>
                                                                                        </asp:ObjectDataSource>
                                                                                        <!--Question 6A : Question Number-->
                                                                                        <asp:HiddenField ID="HiddenQ6A" runat="server" Visible="false" Value="6-A" />

                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </asp:Panel>
                                                <%-- END pnlLossOfConsciousness --%>
                                            </td>
                                        </tr>
                                        <tr id="TrQ7">
                                            <td>
                                                <asp:Panel ID="pnlDisorientationOrConfusion" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q7Label" AssociatedControlID="rblDisorientationOrConfusion" runat="server" CssClass="firstLevelQuestion">
                                                7. Did you have a period of disorientation or confusion immediately following the incident?
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>

                                                                    <asp:RadioButtonList ID="rblDisorientationOrConfusion"
                                                                        runat="server"
                                                                        RepeatDirection="Horizontal"
                                                                        RepeatColumns="2"
                                                                        RepeatLayout="Table"
                                                                        CssClass="fixWidth tbiDiagnosis"
                                                                        DataSourceID="ObjectDataSourceQ7"
                                                                        TabIndex="45"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 7 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="ConfusionRequiredFieldValidator"
                                                                        ControlToValidate="rblDisorientationOrConfusion"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Period of disorientation or confusion immediately following the incident episodes number is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 7 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 7 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />

                                                                </td>
                                                            </tr>
                                                            <tr id="TrQ7A">
                                                                <td>
                                                                    <asp:Panel ID="pnlEstimateDurationOfDisorientationOrConfusion" Width="100%" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q7ALabel" AssociatedControlID="rblDurationOfDisorientationOrConfusion" runat="server" CssClass="firstLevelQuestion">
                                                                7-A. If yes, estimate the duration of longest period of disorientation or confusion.
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>

                                                                                    <td>
                                                                                        <asp:RadioButtonList ID="rblDurationOfDisorientationOrConfusion"
                                                                                            runat="server"
                                                                                            DataSourceID="ObjectDataSourceQ7A"
                                                                                            TabIndex="47"
                                                                                            DataTextField="CHOICE_TEXT"
                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                            RepeatDirection="Horizontal"
                                                                                            RepeatColumns="2"
                                                                                            RepeatLayout="Table"
                                                                                            CssClass="fixWidth"
                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound"
                                                                                            EnableViewState="false">
                                                                                        </asp:RadioButtonList>
                                                                                        <!--Question 7A Required Validator-->
                                                                                        <asp:RequiredFieldValidator ID="ConfusionDurationRequiredFieldValidator"
                                                                                            ControlToValidate="rblDurationOfDisorientationOrConfusion"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="Duration of longest period of disorientation or confusion is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury confusion">
                                                                                        </asp:RequiredFieldValidator>
                                                                                        <!--Question 7A Object Data Source-->
                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ7A" runat="server"
                                                                                            SelectMethod="GetQuestionChoices"
                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                            <SelectParameters>
                                                                                                <asp:ControlParameter ControlID="HiddenQ7A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                            </SelectParameters>
                                                                                        </asp:ObjectDataSource>
                                                                                        <!--Question 7A : Question Number-->
                                                                                        <asp:HiddenField ID="HiddenQ7A" runat="server" Visible="false" Value="7-A" />
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </asp:Panel>
                                            </td>
                                        </tr>
                                        <tr id="TrQ8">
                                            <td>
                                                <%-- START pnlLossOfMemory --%>
                                                <asp:Panel ID="pnlLossOfMemory" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q8Label" AssociatedControlID="rblLossOfMemory" runat="server" CssClass="firstLevelQuestion">
                                                8. Did you experience a period of memory loss immediately before or after the incident?
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:RadioButtonList ID="rblLossOfMemory"
                                                                        runat="server"
                                                                        DataSourceID="ObjectDataSourceQ8"
                                                                        TabIndex="51"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        RepeatDirection="Horizontal"
                                                                        RepeatColumns="2"
                                                                        RepeatLayout="Table"
                                                                        CssClass="fixWidth tbiDiagnosis"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 8 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="MemoryLossRequiredFieldValidator"
                                                                        ControlToValidate="rblLossOfMemory"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Period of memory loss immediately before or after the incident episodes number is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 8 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 8 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:Panel ID="pnlEstimateDurationOfMemoryLoss" Width="100%" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q8ALabel" AssociatedControlID="rblDurationOFMemoryLoss" runat="server" CssClass="firstLevelQuestion">
                                                            8-A. If yes, estimate the duration of longest period of memory loss (Post Traumatic Amnesia (PTA)).
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:RadioButtonList ID="rblDurationOFMemoryLoss"
                                                                                            runat="server"
                                                                                            DataSourceID="ObjectDataSourceQ8A"
                                                                                            TabIndex="55"
                                                                                            DataTextField="CHOICE_TEXT"
                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                            RepeatDirection="Horizontal"
                                                                                            RepeatColumns="2"
                                                                                            RepeatLayout="Table"
                                                                                            CssClass="fixWidth"
                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound"
                                                                                            EnableViewState="false">
                                                                                        </asp:RadioButtonList>
                                                                                        <!--Question 8A Required Validator-->
                                                                                        <asp:RequiredFieldValidator ID="LongestMemoryLossRequiredFieldValidator"
                                                                                            ControlToValidate="rblDurationOFMemoryLoss"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="Longest period of memory loss (Post Traumatic Amnesia (PTA)) is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury memory">
                                                                                        </asp:RequiredFieldValidator>
                                                                                        <!--Question 8A Object Data Source-->
                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ8A" runat="server"
                                                                                            SelectMethod="GetQuestionChoices"
                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                            <SelectParameters>
                                                                                                <asp:ControlParameter ControlID="HiddenQ8A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                            </SelectParameters>
                                                                                        </asp:ObjectDataSource>
                                                                                        <!--Question 8A : Question Number-->
                                                                                        <asp:HiddenField ID="HiddenQ8A" runat="server" Visible="false" Value="8-A" />
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </asp:Panel>
                                                <%-- START pnlLossOfMemory --%>
                                            </td>
                                        </tr>
                                        <tr id="TrQ9">
                                            <td>
                                                <asp:Panel ID="pnlObjectPenetration" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q9Label" AssociatedControlID="rblObjectPenetration" runat="server" CssClass="firstLevelQuestion">
                                                9. During this/these experience(s), did an object penetrate your skull/cranium:
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:RadioButtonList ID="rblObjectPenetration"
                                                                        runat="server"
                                                                        DataSourceID="ObjectDataSourceQ9"
                                                                        TabIndex="59"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        RepeatDirection="Vertical" RepeatColumns="2"
                                                                        RepeatLayout="Table"
                                                                        CssClass="fixWidth"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 9 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="PenetrationRequiredFieldValidator"
                                                                        ControlToValidate="rblObjectPenetration"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Did an object penetrate your skull/cranium is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 9 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 9 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                    <br />
                                                </asp:Panel>
                                            </td>
                                        </tr>
                                        <tr id="TrQ10">
                                            <td>
                                                <asp:Panel ID="pnlProviderConsultationForNewInjury" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q10Label" AssociatedControlID="rblConsultationForNewInjury" runat="server" CssClass="firstLevelQuestion">
                                            10. If you have had a new injury, have you seen any health care providers (doctors/therapists) as a result of the new head injury?
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:RadioButtonList ID="rblConsultationForNewInjury"
                                                                        runat="server"
                                                                        RepeatDirection="Vertical"
                                                                        DataSourceID="ObjectDataSourceQ10"
                                                                        TabIndex="63"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 10 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="NewInjuryRequiredFieldValidator"
                                                                        ControlToValidate="rblConsultationForNewInjury"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Have you seen any health care providers (doctors/therapists) is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass headInjury">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 10 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 10 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                                                                </td>
                                                            </tr>
                                                            <tr id="TrQ10A">
                                                                <td>
                                                                    <asp:Panel ID="pnlProviderChangesMedicationForNewInjury" Width="96%" CssClass="firstLevelQuestion" GroupingText="" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q10ALabel" AssociatedControlID="rblChangeMedicationForNewInjury" runat="server" CssClass="firstLevelQuestion">
                                                            10-A. Did the provider you saw for your new injury change your medications in any way (new type or change in dosage)?
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:RadioButtonList ID="rblChangeMedicationForNewInjury"
                                                                                            runat="server"
                                                                                            RepeatDirection="Vertical"
                                                                                            DataSourceID="ObjectDataSourceQ10A"
                                                                                            TabIndex="65"
                                                                                            DataTextField="CHOICE_TEXT"
                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                        </asp:RadioButtonList>
                                                                                        <!--Question 10a Required Validator-->
                                                                                        <asp:RequiredFieldValidator ID="ChangeMedicationForNewInjuryRequiredFieldValidator"
                                                                                            ControlToValidate="rblChangeMedicationForNewInjury"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="Did the provider you saw for your new injury change your medications in any way is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass headInjury newInjury">
                                                                                        </asp:RequiredFieldValidator>
                                                                                        <!--Question 10a Object Data Source-->
                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ10A" runat="server"
                                                                                            SelectMethod="GetQuestionChoices"
                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                            <SelectParameters>
                                                                                                <asp:ControlParameter ControlID="HiddenQ10A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                            </SelectParameters>
                                                                                        </asp:ObjectDataSource>
                                                                                        <!--Question 10a : Question Number-->
                                                                                        <asp:HiddenField ID="HiddenQ10A" runat="server" Visible="false" Value="10-A" />
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </asp:Panel>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </td>
                        </tr>
                        <tr id="TrChII">
                            <td>
                                <br />
                                <asp:Label ID="lblSymptoms" runat="server" Text="II. Symptoms" Font-Bold="true" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Panel ID="pnlSymptoms" runat="server" Width="100%">
                                    <table width="100%">
                                        <tr id="TrQ11">
                                            <td>
                                                <fieldset>
                                                    <table width="100%" cellpadding="5" cellspacing="5">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="Q11Label" runat="server" CssClass="firstLevelQuestion">
                                                    <b>11. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):</b><br/> 
                                                    <b>&nbsp;&nbsp;None</b> 0 - Rarely if ever present not a problem at all.<br/>
                                                    <b>&nbsp;&nbsp;Mild</b> 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.<br/>
                                                    <b>&nbsp;&nbsp;Moderate</b> 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.<br/>
                                                    <b>&nbsp;&nbsp;Severe</b> 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.<br/>
                                                    <b>&nbsp;&nbsp;Very Severe</b> 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11A">
                                                            <td>
                                                                <asp:Panel ID="pnlDizzyness" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11ALabel" AssociatedControlID="rblDizzyness" runat="server" CssClass="firstLevelQuestion">
                                                                    11-A. Feeling dizzy:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblDizzyness" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11A" TabIndex="67"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11A Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="DizzynessRequiredFieldValidator"
                                                                                        ControlToValidate="rblDizzyness"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Symptoms with regard to how they have affected you over the past 30 days rate is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11A Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11A" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11 A: Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11A" runat="server" Visible="false" Value="11-A" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11B">
                                                            <td>
                                                                <asp:Panel ID="pnlLossOfBalance" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11BLabel" AssociatedControlID="rblLossOfBalance" runat="server" CssClass="firstLevelQuestion">
                                                                    11-B. Loss of Balance:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblLossOfBalance" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11B" TabIndex="69"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11B Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="LossOfBalanceRequiredFieldValidator"
                                                                                        ControlToValidate="rblLossOfBalance"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Loss of Balance level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11B Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11B" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11B" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11B : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11B" runat="server" Visible="false" Value="11-B" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11C">
                                                            <td>
                                                                <asp:Panel ID="pnlPoorCoordination" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11CLabel" AssociatedControlID="rblPoorCoordination" runat="server" CssClass="firstLevelQuestion">
                                                                    11-C. Poor coordination, clumsy:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblPoorCoordination" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11C" TabIndex="71"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11C Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="PoorCoordinationRequiredFieldValidator"
                                                                                        ControlToValidate="rblPoorCoordination"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Poor coordination, clumsy level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11C Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11C" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11C" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11C : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11C" runat="server" Visible="false" Value="11-C" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11D">
                                                            <td>
                                                                <asp:Panel ID="pnlHeadaches" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11DLabel" AssociatedControlID="rblHeadaches" runat="server" CssClass="firstLevelQuestion">
                                                                    11-D. Headaches:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblHeadaches" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11D" TabIndex="73"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11D Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="HeadachesRequiredFieldValidator"
                                                                                        ControlToValidate="rblHeadaches"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Headaches level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11D Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11D" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11D" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11D : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11D" runat="server" Visible="false" Value="11-D" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11E">
                                                            <td>
                                                                <asp:Panel ID="pnlNausea" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11ELabel" AssociatedControlID="rblNausea" runat="server" CssClass="firstLevelQuestion">
                                                                    11-E. Nausea:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblNausea" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11E" TabIndex="75"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11E Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="NauseaRequiredFieldValidator"
                                                                                        ControlToValidate="rblNausea"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Nausea level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11E Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11E" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11E" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11E : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11E" runat="server" Visible="false" Value="11-E" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11F">
                                                            <td>
                                                                <asp:Panel ID="pnlVisionBlurring" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11FLabel" AssociatedControlID="rblVisionBlurring" runat="server" CssClass="firstLevelQuestion">
                                                                    11-F. Vision problems, blurring, trouble seeing:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblVisionBlurring" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11F" TabIndex="77"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11F Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="BlurringRequiredFieldValidator"
                                                                                        ControlToValidate="rblVisionBlurring"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Vision problems, blurring level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11F Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11F" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11F" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11F : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11F" runat="server" Visible="false" Value="11-F" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11G">
                                                            <td>
                                                                <asp:Panel ID="pnlSensitivityToLight" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11GLabel" AssociatedControlID="rblSensitivityToLight" runat="server" CssClass="firstLevelQuestion">
                                                                    11-G. Sensitivity to light:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblSensitivityToLight" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11G" TabIndex="79"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11G Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="SensitivityRequiredFieldValidator"
                                                                                        ControlToValidate="rblSensitivityToLight"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Sensitivity to light level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11G Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11G" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11G" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11G : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11G" runat="server" Visible="false" Value="11-G" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11H">
                                                            <td>
                                                                <asp:Panel ID="pnlHearingDifficulty" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11HLabel" AssociatedControlID="rblHearingDifficulty" runat="server" CssClass="firstLevelQuestion">
                                                                    11-H. Hearing difficulty:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblHearingDifficulty" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11H" TabIndex="81"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11H Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="HearingRequiredFieldValidator"
                                                                                        ControlToValidate="rblHearingDifficulty"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Hearing difficulty level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11H Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11H" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11H" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11H : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11H" runat="server" Visible="false" Value="11-H" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11I">
                                                            <td>
                                                                <asp:Panel ID="PanelSensitivityToNoise" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11ILabel" AssociatedControlID="rblSensitivityToNoise" runat="server" CssClass="firstLevelQuestion">
                                                                    11-I. Sensitivity to noise:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblSensitivityToNoise" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11I" TabIndex="81"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11I Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="NoiseSensitivityRequiredFieldValidator"
                                                                                        ControlToValidate="rblSensitivityToNoise"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Sensitivity to noise level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11I Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11I" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11I" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11I : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11I" runat="server" Visible="false" Value="11-I" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11J">
                                                            <td>
                                                                <asp:Panel ID="PanelNumbnessOrTingling" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11JLabel" AssociatedControlID="rblNumbnessOrTingling" runat="server" CssClass="firstLevelQuestion">
                                                                    11-J. Numbness or tingling on parts of my body:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblNumbnessOrTingling" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11J" TabIndex="83"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11J Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="NumbnessRequiredFieldValidator"
                                                                                        ControlToValidate="rblNumbnessOrTingling"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Numbness or tingling on parts of body level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11J Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11J" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11J" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11J : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11J" runat="server" Visible="false" Value="11-J" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11K">
                                                            <td>
                                                                <asp:Panel ID="PanelChangeInTasteSmell" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11KLabel" AssociatedControlID="rblChangeInTasteSmell" runat="server" CssClass="firstLevelQuestion">
                                                                    11-K. Change in taste and/or smell:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblChangeInTasteSmell" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11K" TabIndex="85"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11K Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="TasteSmellRequiredFieldValidator"
                                                                                        ControlToValidate="rblChangeInTasteSmell"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Change in taste and/or smell level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11K Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11K" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11K" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11K : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11K" runat="server" Visible="false" Value="11-K" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11L">
                                                            <td>
                                                                <asp:Panel ID="PanelAppetiteLossIncrease" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11LLabel" AssociatedControlID="rblAppetiteLossIncrease" runat="server" CssClass="firstLevelQuestion">
                                                                    11-L. Loss of appetite or increase appetite:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblAppetiteLossIncrease" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11L" TabIndex="88"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11L Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="AppetiteRequiredFieldValidator"
                                                                                        ControlToValidate="rblAppetiteLossIncrease"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Loss of appetite or increase appetite level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11L Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11L" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11L" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11L : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11L" runat="server" Visible="false" Value="11-L" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11M">
                                                            <td>
                                                                <asp:Panel ID="PanelPoorConcentration" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11MLabel" AssociatedControlID="rblPoorConcentration" runat="server" CssClass="firstLevelQuestion">
                                                                    11-M. Poor concentration, can't pay attention:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblPoorConcentration" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11M" TabIndex="90"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11M Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="ConcentrationRequiredFieldValidator"
                                                                                        ControlToValidate="rblPoorConcentration"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Poor concentration level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11M Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11M" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11M" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11M : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11M" runat="server" Visible="false" Value="11-M" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11N">
                                                            <td>
                                                                <asp:Panel ID="PanelForgetfulness" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11NLabel" AssociatedControlID="rblForgetfulness" runat="server" CssClass="firstLevelQuestion">
                                                                    11-N. Forgetfulness, can't remember things:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblForgetfulness" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11N" TabIndex="92"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11N Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="ForgetfulnessRequiredFieldValidator"
                                                                                        ControlToValidate="rblForgetfulness"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Forgetfulness, can't remember things level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11N Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11N" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11N" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11N : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11N" runat="server" Visible="false" Value="11-N" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11O">
                                                            <td>
                                                                <asp:Panel ID="PanelDifficultyMakingDecisions" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11OLabel" AssociatedControlID="rblDifficultyMakingDecisions" runat="server" CssClass="firstLevelQuestion">
                                                                    11-O. Difficulty making decisions:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblDifficultyMakingDecisions" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11O" TabIndex="94"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11O Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="DecisionsRequiredFieldValidator"
                                                                                        ControlToValidate="rblDifficultyMakingDecisions"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Difficulty making decisions level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11O Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11O" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11O" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11O : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11O" runat="server" Visible="false" Value="11-O" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11P">
                                                            <td>
                                                                <asp:Panel ID="PanelSlowedThinking" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11PLabel" AssociatedControlID="rblSlowedThinking" runat="server" CssClass="firstLevelQuestion">
                                                                    11-P. Slowed thinking, difficulty getting organized, can't finish things:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblSlowedThinking" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11P" TabIndex="96"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11p Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="SlowedThinkingRequiredFieldValidator"
                                                                                        ControlToValidate="rblSlowedThinking"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Slowed thinking, difficulty getting organized, can't finish things level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11p Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11P" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11P" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11p : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11P" runat="server" Visible="false" Value="11-P" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11Q">
                                                            <td>
                                                                <asp:Panel ID="PanelFatigue" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11QLabel" AssociatedControlID="rblListFatigue" runat="server" CssClass="firstLevelQuestion">
                                                                11-Q. Fatigue, loss of energy, getting tired easily:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblListFatigue" runat="server" CssClass="fixWidth" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11Q" TabIndex="98"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11 Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="FatigueRequiredFieldValidator"
                                                                                        ControlToValidate="rblListFatigue"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Fatigue, loss of energy, getting tired easily level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11 Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11Q" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11Q" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11 : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11Q" runat="server" Visible="false" Value="11-Q" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11R">
                                                            <td>
                                                                <asp:Panel ID="PanelSleepDifficulty" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11RLabel" AssociatedControlID="rblSleepDifficulty" runat="server" CssClass="firstLevelQuestion">
                                                                    11-R. Difficulty falling or staying asleep:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblSleepDifficulty" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11R" TabIndex="100"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="fixWidth"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11r Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="SleepingRequiredFieldValidator"
                                                                                        ControlToValidate="rblSleepDifficulty"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Difficulty falling or staying asleep level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11r Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11R" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11R" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11r : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11R" runat="server" Visible="false" Value="11-R" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11S">
                                                            <td>
                                                                <asp:Panel ID="PanelAnxiety" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11SLabel" AssociatedControlID="rblAnxiety" runat="server" CssClass="firstLevelQuestion">
                                                                11-S. Feeling anxious or tense:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblAnxiety" runat="server" RepeatDirection="Horizontal" CssClass="fixWidth" DataSourceID="ObjectDataSourceQ11S" TabIndex="102"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11s Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="AnxietyRequiredFieldValidator"
                                                                                        ControlToValidate="rblAnxiety"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Feeling anxious or tense level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11s Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11S" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11S" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11s : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11S" runat="server" Visible="false" Value="11-S" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11T">
                                                            <td>
                                                                <asp:Panel ID="PanelDepression" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11TLabel" AssociatedControlID="rblDepression" runat="server" CssClass="firstLevelQuestion">
                                                                11-T. Feeling depressed or sad:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblDepression" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11T" TabIndex="104"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11t Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="DepressionRequiredFieldValidator"
                                                                                        ControlToValidate="rblDepression"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Feeling depressed or sad level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11t Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11T" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11T" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11t : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11T" runat="server" Visible="false" Value="11-T" />

                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11U">
                                                            <td>
                                                                <asp:Panel ID="PanelIrritability" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11ULabel" AssociatedControlID="rblIrritability" runat="server" CssClass="firstLevelQuestion">
                                                                11-U. Irritability, easily annoyed:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblIrritability" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11U" TabIndex="106"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11u Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="IrritabilityRequiredFieldValidator"
                                                                                        ControlToValidate="rblIrritability"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Irritability, easily annoyed level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11u Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11U" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11U" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11u : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11U" runat="server" Visible="false" Value="11-U" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                        <tr id="TrQ11V">
                                                            <td>
                                                                <asp:Panel ID="PanelFrustration" Width="100%" runat="server">
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="Q11VLabel" AssociatedControlID="rblFrustration" runat="server" CssClass="firstLevelQuestion">
                                                                11-V. Poor frustration tolerance, feeling easily overwhelmed by things:
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:RadioButtonList ID="rblFrustration" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11V" TabIndex="108"
                                                                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        OnDataBound="RadioButtonList_Common_OnDataBound" CssClass="fixWidth">
                                                                                    </asp:RadioButtonList>
                                                                                    <!--Question 11v Required Validator-->
                                                                                    <asp:RequiredFieldValidator ID="FrustrationRequiredFieldValidator"
                                                                                        ControlToValidate="rblFrustration"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Poor frustration tolerance, feeling easily overwhelmed by things level is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                                    </asp:RequiredFieldValidator>
                                                                                    <!--Question 11v Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ11V" runat="server"
                                                                                        SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ11V" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 11v : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ11V" runat="server" Visible="false" Value="11-V" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </asp:Panel>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </fieldset>
                                            </td>
                                        </tr>
                                        <tr id="TrQ12">
                                            <td>
                                                <asp:Panel ID="pnlOverallInterferenceWithLife" Width="100%" runat="server">
                                                    <fieldset>
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr class="questionBackgroundColor">
                                                                <td>
                                                                    <asp:Label ID="Q12Label" AssociatedControlID="rblOverallInterferenceWithLife" runat="server" CssClass="firstLevelQuestion">
                                                    12. Overall, in the last 30 days how much did these difficulties (symptoms) interfere with your life?
                                                                    </asp:Label>
                                                                    <br />
                                                                    <br />
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:RadioButtonList ID="rblOverallInterferenceWithLife"
                                                                        runat="server"
                                                                        DataSourceID="ObjectDataSourceQ12"
                                                                        TabIndex="110"
                                                                        DataTextField="CHOICE_TEXT"
                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                        RepeatDirection="Horizontal"
                                                                        RepeatColumns="2"
                                                                        RepeatLayout="Table"
                                                                        CssClass="fixWidth"
                                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                    </asp:RadioButtonList>
                                                                    <!--Question 12 Required Validator-->
                                                                    <asp:RequiredFieldValidator ID="InterferenceRequiredFieldValidator"
                                                                        ControlToValidate="rblOverallInterferenceWithLife"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage="Overall, in the last 30 days how much did these difficulties (symptoms) interference with your life level is required."
                                                                        SetFocusOnError="true"
                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                    </asp:RequiredFieldValidator>
                                                                    <!--Question 12 Object Data Source-->
                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server"
                                                                        SelectMethod="GetQuestionChoices"
                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                        <SelectParameters>
                                                                            <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                                                        </SelectParameters>
                                                                    </asp:ObjectDataSource>
                                                                    <!--Question 12 : Question Number-->
                                                                    <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                                                                </td>
                                                            </tr>
                                                            <tr id="TrQ12A">
                                                                <td>
                                                                    <asp:Panel ID="pnlAreasOfLifeAffected" Width="100%" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q12ALabel" AssociatedControlID="tbxAreasOfLifeAffected" runat="server" CssClass="firstLevelQuestion">
                                                                12-A. In what areas of your life are you having difficulties because of these symptoms?
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:TextBox ID="tbxAreasOfLifeAffected" runat="server"
                                                                                            TextMode="MultiLine" Width="100%">
                                                                                        </asp:TextBox>
                                                                                        <asp:RequiredFieldValidator ID="LifeAreasRequiredFieldValidator"
                                                                                            ControlToValidate="tbxAreasOfLifeAffected"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="Areas of your life you having difficulties because of these symptoms is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass symptoms">
                                                                                        </asp:RequiredFieldValidator>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </asp:Panel>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="TrChIII">
                            <td>
                                <br />
                                <asp:Label ID="lblPainSection" runat="server" Text="III. Pain" Font-Bold="true" />
                            </td>
                        </tr>
                        <tr id="TrQ13">
                            <td>
                                <asp:Panel ID="pnlProblemsWithPain" Width="100%" runat="server">
                                    <fieldset>
                                        <table width="100%" cellpadding="5" cellspacing="5">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q13Label" AssociatedControlID="rblProblemsWithPain" runat="server" CssClass="firstLevelQuestion">
                                        13. In the last 30 days, have you had any problems with pain?
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="rblProblemsWithPain"
                                                        runat="server"
                                                        RepeatDirection="Horizontal"
                                                        RepeatColumns="2"
                                                        DataSourceID="ObjectDataSourceQ13"
                                                        TabIndex="112"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        CssClass="fixWidth"
                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                    </asp:RadioButtonList>
                                                    <!--Question 13 Required Validator-->
                                                    <asp:RequiredFieldValidator ID="PainRequiredFieldValidator"
                                                        ControlToValidate="rblProblemsWithPain"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="In the last 30 days, have you had any problems with pain is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                    </asp:RequiredFieldValidator>
                                                    <!--Question 13 Object Data Source-->
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <!--Question 13 : Question Number-->
                                                    <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="painSection">
                                                        <table width="100%" cellpadding="5" cellspacing="5">
                                                            <tr id="TrQ13A">
                                                                <td>
                                                                    <fieldset class="firstLevelAnswer">
                                                                        <table width="100%">
                                                                            <tr class="subquestionBackgroundColor">
                                                                                <td>
                                                                                    <asp:Label ID="lblIfYesCheckAllThatApply" AssociatedControlID="cblProblemsWithPain" runat="server" CssClass="firstLevelQuestion">
                                                                    13-A. If yes, location(s) (Check all that apply):
                                                                                    </asp:Label>
                                                                                    <br />
                                                                                    <br />
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <asp:CheckBoxList ID="cblProblemsWithPain"
                                                                                        runat="server"
                                                                                        DataSourceID="ObjectDataSourceQ13A"
                                                                                        TabIndex="112"
                                                                                        DataTextField="CHOICE_TEXT"
                                                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                        RepeatDirection="Horizontal" RepeatColumns="2"
                                                                                        RepeatLayout="Table"
                                                                                        CssClass="fixWidth"
                                                                                        OnDataBound="cblProblemsWithPain_OnDataBound">
                                                                                    </asp:CheckBoxList>
                                                                                    <web:RequiredFieldValidatorForCheckBoxLists ID="PainProblemsValidator"
                                                                                        ControlToValidate="cblProblemsWithPain"
                                                                                        Display="Dynamic"
                                                                                        runat="server"
                                                                                        EnableClientScript="true"
                                                                                        ErrorMessage="Pain location(s) is required."
                                                                                        SetFocusOnError="true"
                                                                                        ValidationGroup="OnSave" CssClass="ValidatorClass pain">
                                                                                    </web:RequiredFieldValidatorForCheckBoxLists>
                                                                                    <!--Question 13A Object Data Source-->
                                                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ13A" runat="server" SelectMethod="GetQuestionChoices"
                                                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                        <SelectParameters>
                                                                                            <asp:ControlParameter ControlID="HiddenQ13A" Direction="Input" Name="questionNumber" Type="String" />
                                                                                        </SelectParameters>
                                                                                    </asp:ObjectDataSource>
                                                                                    <!--Question 13A : Question Number-->
                                                                                    <asp:HiddenField ID="HiddenQ13A" runat="server" Visible="false" Value="13-A" />
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </fieldset>
                                                                </td>
                                                            </tr>
                                                            <tr id="TrQ13B">
                                                                <td>
                                                                    <asp:Panel ID="pnlPainInterferenceWithLife" Width="100%" runat="server">
                                                                        <fieldset class="firstLevelAnswer">
                                                                            <table width="100%">
                                                                                <tr class="subquestionBackgroundColor">
                                                                                    <td>
                                                                                        <asp:Label ID="Q13BLabel" AssociatedControlID="rblPainInterferenceWithLife" runat="server" CssClass="firstLevelQuestion">
                                                                        13-B. If yes, in the last 30 days, how much did pain interfere with your life?
                                                                                        </asp:Label>
                                                                                        <br />
                                                                                        <br />
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:RadioButtonList ID="rblPainInterferenceWithLife"
                                                                                            runat="server"
                                                                                            DataSourceID="ObjectDataSourceQ13B"
                                                                                            TabIndex="114"
                                                                                            DataTextField="CHOICE_TEXT"
                                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                            RepeatDirection="Horizontal"
                                                                                            RepeatColumns="2"
                                                                                            RepeatLayout="Table"
                                                                                            CssClass="fixWidth"
                                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                                        </asp:RadioButtonList>
                                                                                        <!--Question 13B Required Validator-->
                                                                                        <asp:RequiredFieldValidator ID="PainInterferenceRequiredFieldValidator"
                                                                                            ControlToValidate="rblPainInterferenceWithLife"
                                                                                            Display="Dynamic"
                                                                                            runat="server"
                                                                                            EnableClientScript="true"
                                                                                            ErrorMessage="In the last 30 days, how much did pain interfere with your life level is required."
                                                                                            SetFocusOnError="true"
                                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass pain">
                                                                                        </asp:RequiredFieldValidator>
                                                                                        <!--Question 13B Object Data Source-->
                                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ13B" runat="server"
                                                                                            SelectMethod="GetQuestionChoices"
                                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                            <SelectParameters>
                                                                                                <asp:ControlParameter ControlID="HiddenQ13B" Direction="Input" Name="questionNumber" Type="String" />
                                                                                            </SelectParameters>
                                                                                        </asp:ObjectDataSource>
                                                                                        <!--Question 13B : Question Number-->
                                                                                        <asp:HiddenField ID="HiddenQ13B" runat="server" Visible="false" Value="13-B" />
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </fieldset>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="TrQ14">
                            <td>
                                <asp:Panel ID="PanelOverallSymptomsSinceLastEval" Width="100%" runat="server">
                                    <fieldset>
                                        <table width="100%" cellpadding="5" cellspacing="5">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q14Label" AssociatedControlID="RadioButtonListOverallSymptomsSinceLastEval" runat="server" CssClass="firstLevelQuestion">
                                    14. Since your last evaluation, are your overall symptoms:
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="RadioButtonListOverallSymptomsSinceLastEval"
                                                        runat="server"
                                                        RepeatDirection="Horizontal"
                                                        DataSourceID="ObjectDataSourceQ14"
                                                        TabIndex="116"
                                                        CssClass="fixWidth"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                    </asp:RadioButtonList>
                                                    <!--Question 14 Required Validator-->
                                                    <asp:RequiredFieldValidator ID="SymptomsRequiredFieldValidator"
                                                        ControlToValidate="RadioButtonListOverallSymptomsSinceLastEval"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Since your last evaluation, your overall symptoms is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                    </asp:RequiredFieldValidator>
                                                    <!--Question 14 Object Data Source-->
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <!--Question 14 : Question Number-->
                                                    <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="TrQ15">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="lblAdditionalComments" AssociatedControlID="tbxAdditionalComments" runat="server" CssClass="firstLevelQuestion">
                                    15. Additional comments regarding current symptoms/functional status:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="tbxAdditionalComments" runat="server" TextMode="MultiLine"
                                                    Height="67px" Width="100%" TabIndex="118">
                                                </asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ16">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="CurrentMedicationLabel" Text="16. Current medications:" AssociatedControlID="CurrentMedicationTextBox" runat="server" CssClass="firstLevelQuestion" />
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="CurrentMedicationTextBox" runat="server" TextMode="MultiLine" Height="67px" Width="100%" TabIndex="119"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table width="100%" cellpadding="5" cellspacing="5">
                                                    <tr class="subquestionBackgroundColor">
                                                        <td>
                                                            <asp:Label ID="lblMedicationReconciliationPerformed" Text="16-A. Was a medication reconciliation performed?" AssociatedControlID="rblMedicationReconciliationPerformed" runat="server" CssClass="firstLevelQuestion" />
                                                            <br />
                                                            <br />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:RadioButtonList ID="rblMedicationReconciliationPerformed" runat="server" RepeatDirection="Vertical" TabIndex="120"
                                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false"
                                                                onclick="rblMedicationReconciliationPerformed_CheckChanged()">
                                                            </asp:RadioButtonList>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table id="tblMedicationGiven" width="100%" cellpadding="5" cellspacing="5" border="0">
                                                    <tr class="subquestionBackgroundColor">
                                                        <td>
                                                            <asp:Label ID="lblMedicationGiven" Text="16-B. Was a printed medication list given to the patient?" AssociatedControlID="rblMedicationGiven" runat="server" CssClass="firstLevelQuestion" />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:RadioButtonList ID="rblMedicationGiven" runat="server" RepeatDirection="Vertical" TabIndex="121"
                                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                                            </asp:RadioButtonList>
                                                        </td>
                                                    </tr>
                                                </table>
                                                &nbsp;
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table id="tblNoMedicationReconciliationPerformed" width="100%" cellpadding="5" cellspacing="5" border="0">
                                                    <tr class="subquestionBackgroundColor">
                                                        <td>
                                                            <asp:Label ID="lblNoMedicationReconciliationPerformed" Text="Please explain in free text box below:" AssociatedControlID="txtNoMedicationReconciliationPerformed" runat="server" CssClass="firstLevelQuestion" />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="txtNoMedicationReconciliationPerformed" runat="server" TextMode="MultiLine" Height="67px" Width="100%" TabIndex="122" />
                                                        </td>
                                                    </tr>
                                                </table>
                                                &nbsp;
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ17">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="lblPhysicalExam" AssociatedControlID="tbxPhysicalExam" runat="server" CssClass="firstLevelQuestion">
                                    17. Physical Examination:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="tbxPhysicalExam" runat="server" TextMode="MultiLine"
                                                    Height="67px" Width="100%" TabIndex="123">
                                                </asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrQ18">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="lblProfessionalAssessment" AssociatedControlID="tbxProfessionalAssessment" runat="server" CssClass="firstLevelQuestion">
                                    18. Professional Conclusion/Assessment:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="tbxProfessionalAssessment" runat="server" TextMode="MultiLine"
                                                    Height="67px" Width="100%" TabIndex="124">
                                                </asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr id="TrChIV">
                            <td>
                                <br />
                                <asp:Label ID="lblDiagnosisSection" runat="server" Text="IV. Diagnosis" Font-Bold="true" />
                            </td>
                        </tr>
                        <tr id="TrQ19">
                            <td>
                                <asp:Panel ID="pnlExperiencedNewTbi" Width="100%" runat="server">
                                    <fieldset>
                                        <table width="100%" cellpadding="5" cellspacing="5">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q19Label" AssociatedControlID="rblExperiencedNewTbi" runat="server" CssClass="firstLevelQuestion">
                                        19. Based on the history of the injury and the course of clinical symptoms, has the Veteran experienced a new TBI since their last diagnosis?
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="rblExperiencedNewTbi"
                                                        runat="server"
                                                        DataSourceID="ObjectDataSourceQ19"
                                                        TabIndex="125"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        RepeatDirection="Vertical"
                                                        RepeatColumns="2"
                                                        RepeatLayout="Table"
                                                        CssClass="fixWidth"
                                                        OnDataBound="RadioButtonList_Common_OnDataBound"
                                                        EnableViewState="false">
                                                    </asp:RadioButtonList>
                                                    <!--Question 19 Required Validator-->
                                                    <asp:RequiredFieldValidator ID="NewTBIRequiredFieldValidator"
                                                        ControlToValidate="rblExperiencedNewTbi"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Has the patient experienced a new TBI since their last diagnosis is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                    </asp:RequiredFieldValidator>
                                                    <!--Question 19 Object Data Source-->
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <!--Question 19 : Question Number-->
                                                    <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                                                </td>
                                            </tr>
                                            <tr id="TrQ19A">
                                                <td>
                                                    <asp:Panel ID="PanelClinicalJudgement" Width="100%" runat="server">
                                                        <fieldset class="firstLevelAnswer">
                                                            <table width="100%" cellpadding="5" cellspacing="5">
                                                                <tr class="subquestionBackgroundColor">
                                                                    <td>
                                                                        <asp:Label ID="Q19ALabel" AssociatedControlID="RadioButtonListClinicalJudgement" runat="server" CssClass="firstLevelQuestion">
                                                            19-A. In your clinical judgment the current clinical symptom presentation is most consistent with:
                                                                        </asp:Label>
                                                                        <br />
                                                                        <br />
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <asp:RadioButtonList ID="RadioButtonListClinicalJudgement"
                                                                            runat="server"
                                                                            RepeatDirection="Vertical"
                                                                            RepeatLayout="Table"
                                                                            DataSourceID="ObjectDataSourceQ19A"
                                                                            TabIndex="127"
                                                                            DataTextField="CHOICE_TEXT"
                                                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                                                            CssClass="fixWidth"
                                                                            OnDataBound="RadioButtonList_Common_OnDataBound">
                                                                        </asp:RadioButtonList>
                                                                        <!--Question 19A Required Validator-->
                                                                        <asp:RequiredFieldValidator ID="ClinicalJudgementValidator"
                                                                            ControlToValidate="RadioButtonListClinicalJudgement"
                                                                            Display="Dynamic"
                                                                            runat="server"
                                                                            EnableClientScript="true"
                                                                            ErrorMessage="In your clinical judgment the current clinical symptom presentation is most consistent with is required."
                                                                            SetFocusOnError="true"
                                                                            ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                                        </asp:RequiredFieldValidator>
                                                                        <!--Question 19A Object Data Source-->
                                                                        <asp:ObjectDataSource ID="ObjectDataSourceQ19A" runat="server"
                                                                            SelectMethod="GetQuestionChoices"
                                                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                            <SelectParameters>
                                                                                <asp:ControlParameter ControlID="HiddenQ19A" Direction="Input" Name="questionNumber" Type="String" />
                                                                            </SelectParameters>
                                                                        </asp:ObjectDataSource>
                                                                        <!--Question 19A : Question Number-->
                                                                        <asp:HiddenField ID="HiddenQ19A" runat="server" Visible="false" Value="19-A" />
                                                                    </td>
                                                                </tr>
                                                                <tr id="TrQ19A1">
                                                                    <td>
                                                                        <asp:Panel ID="PanelOtherCondition" Width="100%" runat="server">
                                                                            <fieldset class="secondLevelQuestion">
                                                                                <table width="100%">
                                                                                    <tr class="questionBackgroundColor">
                                                                                        <td>
                                                                                            <asp:Label ID="Q19A1Label" AssociatedControlID="OtherConditionDetailsTextBox" runat="server" CssClass="firstLevelQuestion">
                                                                                19-A-1. Other condition details:
                                                                                            </asp:Label>
                                                                                            <br />
                                                                                            <br />
                                                                                        </td>
                                                                                    </tr>
                                                                                    <tr>
                                                                                        <td>
                                                                                            <asp:TextBox ID="OtherConditionDetailsTextBox" runat="server"
                                                                                                TextMode="MultiLine" Width="100%" Value="1" TabIndex="129" />
                                                                                            <asp:RequiredFieldValidator ID="OtherDetailsValidator"
                                                                                                ControlToValidate="OtherConditionDetailsTextBox"
                                                                                                Display="Dynamic"
                                                                                                runat="server"
                                                                                                EnableClientScript="true"
                                                                                                ErrorMessage="Other condition details is required."
                                                                                                SetFocusOnError="true"
                                                                                                ValidationGroup="OnSave" CssClass="ValidatorClass judgement">
                                                                                            </asp:RequiredFieldValidator>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>
                                                                            </fieldset>
                                                                        </asp:Panel>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </fieldset>
                                                    </asp:Panel>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="TrChV">
                            <td>
                                <br />
                                <asp:Label ID="lblPlanSection" runat="server" Text="V. Plan" Font-Bold="true" />
                            </td>
                        </tr>
                        <tr id="TrQ20">
                            <td>
                                <asp:Panel ID="pnlFollowUpPlan" Width="100%" runat="server">
                                    <fieldset>
                                        <table width="100%" cellpadding="5" cellspacing="5">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q20Label" AssociatedControlID="rblFollowUpPlan" runat="server" CssClass="firstLevelQuestion">
                                    20. Follow-up Plan:
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="rblFollowUpPlan"
                                                        runat="server"
                                                        RepeatDirection="Vertical"
                                                        DataSourceID="ObjectDataSourceQ20"
                                                        TabIndex="130"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        OnDataBound="RadioButtonList_Common_OnDataBound">
                                                    </asp:RadioButtonList>
                                                    <!--Question 20 Required Validator-->
                                                    <asp:RequiredFieldValidator ID="FollowUpPlanValidator"
                                                        ControlToValidate="rblFollowUpPlan"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Follow-up Plan is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" CssClass="ValidatorClass">
                                                    </asp:RequiredFieldValidator>
                                                    <!--Question 20 Object Data Source-->
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <!--Question 20 : Question Number-->
                                                    <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="TrQ21">
                            <td>
                                <fieldset>
                                    <table width="100%" cellpadding="5" cellspacing="5">
                                        <tr class="questionBackgroundColor">
                                            <td>
                                                <asp:Label ID="lblDetailsOfPlan" AssociatedControlID="tbxDetailsOfPlan" runat="server" CssClass="firstLevelQuestion">
                                    21. Details Of Plan:
                                                </asp:Label>
                                                <br />
                                                <br />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="tbxDetailsOfPlan" runat="server" TextMode="MultiLine"
                                                    Height="67px" Width="100%" TabIndex="132">
                                                </asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Button ID="btnSaveSurveyDraft"
                                    runat="server"
                                    UseSubmitBehavior="false"
                                    Text="Save Draft"
                                    Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                    ValidationGroup="OnSaveDraft"
                                    TabIndex="133" />

                                <asp:Button ID="btnSubmitSurvey"
                                    runat="server"
                                    UseSubmitBehavior="false"
                                    Text="Save and Prepare Note"
                                    Width="180px"
                                    OnClick="btnSubmit_Click"
                                    ValidationGroup="OnSave"
                                    TabIndex="134" />

                                <asp:Button ID="btnCancelSurvey"
                                    runat="server"
                                    TabIndex="135"
                                    UseSubmitBehavior="false"
                                    Text="Cancel"
                                    Width="130px"
                                    OnClick="btnCancel_Click" />

                                <br />
                                <br />
                                <asp:Label ID="Label8" runat="server" SkinID="DataLabel">
                            If you are unable to finish at this time, or if you just want to save while entering, click Save Draft.<br /><br />

                            If you are finished with entry, and ready to save and format the note (you will get another chance to review prior to submit),<br /> 
                            click Save and Prepare Note.<br /><br />     
                              
                            If you want to return to CPRS press the Cancel Button. Do not use Internet browser back arrow.               
                                </asp:Label>
                                <br />
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <br />
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 320px; color: #FFFFFF; padding: 5px;">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                            </div>
                        </div>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <br />

            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
